# -----------------------------------------------------------------------------------------
#  $Id: update_2.0.6.0_to_2.0.7.0.sql 14470 2022-05-17 10:47:29Z Tomcraft $
#
#  modified eCommerce Shopsoftware
#  http://www.modified-shop.org
#
#  Copyright (c) 2009 - 2013 [www.modified-shop.org]
#  -----------------------------------------------------------------------------------------

#Tomcraft - 2021-05-06 - changed database_version
INSERT INTO `database_version` (`version`) VALUES ('MOD_2.0.7.0');

#Tomcraft - 2021-05-06 - fix multilanguage for tax rates and tax classes
UPDATE `geo_zones` SET `geo_zone_description` = 'DE::Steuerzone fr die EU||EN::Tax zone for the EU' WHERE `geo_zone_description` = 'Steuerzone fr die EU';
#UPDATE `geo_zones` SET `geo_zone_description` = 'DE::Steuerzone fr B2B||EN::Tax zone for B2B' WHERE `geo_zone_description` = 'Steuerzone fr B2B';
UPDATE `geo_zones` SET `geo_zone_description` = 'DE::Steuerzone fr B2B||EN::Tax zone for B2B' WHERE `geo_zone_name` = 'DE::Steuerzone B2B||EN::Tax zone B2B';
UPDATE `geo_zones` SET `geo_zone_description` = 'DE::Steuerzone fr CH/LI||EN::Tax zone for CH/LI' WHERE `geo_zone_description` = 'Steuerzone fr CH/LI';
UPDATE `geo_zones` SET `geo_zone_description` = 'DE::Steuerzone fr DE||EN::Tax zone for DE' WHERE `geo_zone_description` = 'Steuerzone fr DE';

UPDATE `tax_rates` SET `tax_description` = 'DE::EU-AUS-UST 0%||EN::EU-OUT-VAT 0%' WHERE `tax_description` = 'EU-AUS-UST 0%';
UPDATE `tax_rates` SET `tax_description` = 'DE::EU-AUS-UST 0%||EN::EU-OUT-VAT 0%' WHERE `tax_description` = 'DE::EU-AUS-UST 0%';
UPDATE `tax_rates` SET `tax_description` = 'DE::MwSt. 7%||EN::VAT 7%' WHERE `tax_description` = 'MwSt. 7%';
UPDATE `tax_rates` SET `tax_description` = 'DE::MwSt. 7%||EN::VAT 7%' WHERE `tax_description` = 'DE::MwSt. 7%';
UPDATE `tax_rates` SET `tax_description` = 'DE::MwSt. 19%||EN::VAT 19%' WHERE `tax_description` = 'MwSt. 19%';
UPDATE `tax_rates` SET `tax_description` = 'DE::MwSt. 19%||EN::VAT 19%' WHERE `tax_description` = 'DE::MwSt. 19%';

#GTB - 2021-06-09 - add tax for geo zones
ALTER TABLE `geo_zones` ADD `geo_zone_tax` INT(1) DEFAULT 0 AFTER `geo_zone_info`;
CREATE TABLE products_geo_zones_to_tax_class (
  `products_id` INT(11) NOT NULL,
  `geo_zone_id` INT(11) NOT NULL,
  `tax_class_id` INT(11) NOT NULL,
  PRIMARY KEY (`products_id`, `geo_zone_id`)
);

#GTB - 2021-07-13 - add sort_order for geo tax_class
ALTER TABLE `tax_class` ADD `sort_order` INT(11) DEFAULT 0 NOT NULL AFTER `tax_class_description`; 

#GTB - 2021-07-30 - add index for startpage
ALTER TABLE `products` ADD KEY `idx_products_startpage` (`products_startpage`); 

#GTB - 2021-09-06 - add index for status
ALTER TABLE `languages` ADD KEY `idx_status_admin` (`status_admin`);
ALTER TABLE `currencies` ADD KEY `idx_status` (`status`);
ALTER TABLE `content_manager` ADD KEY `idx_content_status` (`content_status`);
ALTER TABLE `module_newsletter` ADD KEY `idx_status` (`status`);
ALTER TABLE `newsletter_recipients` ADD KEY `idx_mail_status` (`mail_status`);
ALTER TABLE `newsletters` ADD KEY `idx_status` (`status`);
ALTER TABLE `products_tags_options` ADD KEY `idx_status` (`status`);
ALTER TABLE `products_tags_values` ADD KEY `idx_status` (`status`);
ALTER TABLE `reviews` ADD KEY `idx_reviews_status` (`reviews_status`);

#GTB - 2021-09-06 - add index for newsfeed date
ALTER TABLE `newsfeed` ADD KEY `idx_news_date` (`news_date`);

#GTB - 2021-09-07 - add index for sorting
ALTER TABLE `banners` ADD KEY `idx_banners_sort` (`banners_sort`);
ALTER TABLE `carriers` ADD KEY `idx_carrier_sort_order` (`carrier_sort_order`);
ALTER TABLE `categories` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `configuration` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `configuration_group` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `content_manager` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `languages` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `orders_status` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `orders_total` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `products` ADD KEY `idx_products_sort` (`products_sort`);
ALTER TABLE `products` ADD KEY `idx_products_startpage_sort` (`products_startpage_sort`);
ALTER TABLE `products_attributes` ADD KEY `idx_sortorder` (`sortorder`);
ALTER TABLE `products_options` ADD KEY `idx_products_options_sortorder` (`products_options_sortorder`);
ALTER TABLE `products_options_values` ADD KEY `idx_products_options_values_sortorder` (`products_options_values_sortorder`);
ALTER TABLE `products_tags` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `products_tags_options` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `products_tags_values` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `products_xsell` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `products_xsell_grp_name` ADD KEY `idx_xsell_sort_order` (`xsell_sort_order`);
ALTER TABLE `shipping_status` ADD KEY `idx_sort_order` (`sort_order`);
ALTER TABLE `tax_class` ADD KEY `idx_sort_order` (`sort_order`);

#GTB - 2021-09-07 - add index for options_name
ALTER TABLE `products_tags_options` ADD KEY `idx_options_name` (`options_name`);

#GTB - 2021-09-07 - add index for values_name
ALTER TABLE `products_tags_values` ADD KEY `idx_values_name` (`values_name`);

#GTB - 2021-09-07 - add index for tax_priority
ALTER TABLE `tax_rates` ADD KEY `idx_tax_priority` (`tax_priority`);

#GTB - 2021-09-07 - add index for image_nr
ALTER TABLE `products_images` ADD KEY `idx_image_nr` (`image_nr`);

#Tomcraft - 2021-10-04 - fix #1711 - revised Shopvote, including multi language support
DELETE FROM configuration WHERE configuration_key = 'MODULE_SHIPPING_EASYREVIEWS';
DELETE FROM configuration WHERE configuration_key = 'MODULE_SHIPPING_RATINGSTARS';

#GTB - 2021-09-07 - add index for products_image
ALTER TABLE `products` ADD KEY `idx_products_image` (`products_image`);

#Tomcraft - 2021-11-08 - revised coupon text in content manager - removed tables
# shop version 1.00
UPDATE `content_manager` SET `content_text` = '<p><strong>Gutscheine kaufen </strong></p>\r\n<p>Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</p>\r\n<p><strong>Wie man Gutscheine versendet</strong></p>\r\n<p>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</p>\r\n<p><strong>Mit Gutscheinen einkaufen.</strong></p>\r\n<p>Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</p>\r\n<p><strong>Gutscheine verbuchen. </strong></p>\r\n<p>Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen:<br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen.<br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</p>\r\n<p><strong>Falls es zu Problemen kommen sollte:</strong></p>\r\n<p>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5").</p>' WHERE `content_text` = '<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Gutscheine kaufen </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden. </td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Wie man Gutscheine versendet </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren. </td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Mit Gutscheinen Einkaufen. </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung. </td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Gutscheine verbuchen. </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen:. <br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen. <br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Falls es zu Problemen kommen sollte: </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail : you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser. </td></tr></tbody></table>';
# shop version 1.01 - 1.04
UPDATE `content_manager` SET `content_text` = '<p><strong>Buy Gift Vouchers/Coupons </strong></p>\r\n<p>If the shop provided gift vouchers or coupons, You can buy them alike all other products. As soon as You have bought and payed the coupon, the shop system will activate Your coupon. You will then see the coupon amount in Your shopping cart. Then You can send the coupon via e-mail by clicking the link "Send Coupon".</p>\r\n<p><strong>How to dispatch Coupons </strong></p>\r\n<p>To dispatch a coupon, please click the link "Send Coupon" in Your shopping cart. To send the coupon to the correct person, we need the following details: Surname and realname of the recipient and a valid e-mail adress of the recipient, and the desired coupon amount (You can also use only parts of Your balance). Please provide also a short message for the recipient. Please check those information again before You click the "Send Coupon" button. You can change all information at any time before clicking the "Send Coupon" button.</p>\r\n<p><strong>How to use Coupons to buy products. </strong></p>\r\n<p>As soon as You have a balance, You can use it to pay for Your orders. During the checkout process, You can redeem Your coupon. In case Your balance is less than the value of goods You ordered, You would have to choose Your preferred method of payment for the difference amount. In case Your balance is more than the value of goods You ordered, the remaining amount of Your balance will be saved for Your next order.</p>\r\n<p><strong>How to redeem Coupons. </strong></p>\r\n<p>In case You have received a coupun via e-mail, You can:<br />1. Click on the link provided in the e-mail. If You do not have an account in this shop already, please create a personal account.<br />2. After having added a product to Your shopping cart, You can enter Your coupon code.</p>\r\n<p><strong>Problems?</strong></p>\r\n<p>If You have trouble or problems in using Your coupons, please check back with us via our e-mail: you@yourdomain.com. Please describe the encountered problem as detailed as possible! We need the following information to process Your request quickly: Your user id, the coupon code, error messages the shop system returned to You, and the name of the web browser You are using (e.g. "Internet Explorer 6" or "Firefox 1.5").</p>' WHERE `content_text` = '<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Buy Gift Vouchers/Coupons </strong></td></tr>\r\n<tr>\r\n<td class="main">If the shop provided gift vouchers or coupons, You can buy them alike all other products. As soon as You have bought and payed the coupon, the shop system will activate Your coupon. You will then see the coupon amount in Your shopping cart. Then You can send the coupon via e-mail by clicking the link "Send Coupon". </td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>How to dispatch Coupons </strong></td></tr>\r\n<tr>\r\n<td class="main">To dispatch a coupon, please click the link "Send Coupon" in Your shopping cart. To send the coupon to the correct person, we need the following details: Surname and realname of the recipient and a valid e-mail adress of the recipient, and the desired coupon amount (You can also use only parts of Your balance). Please provide also a short message for the recipient. Please check those information again before You click the "Send Coupon" button. You can change all information at any time before clicking the "Send Coupon" button. </td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>How to use Coupons to buy products. </strong></td></tr>\r\n<tr>\r\n<td class="main">As soon as You have a balance, You can use it to pay for Your orders. During the checkout process, You can redeem Your coupon. In case Your balance is less than the value of goods You ordered, You would have to choose Your preferred method of payment for the difference amount. In case Your balance is more than the value of goods You ordered, the remaining amount of Your balance will be saved for Your next order. </td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>How to redeem Coupons. </strong></td></tr>\r\n<tr>\r\n<td class="main">In case You have received a coupun via e-mail, You can: <br />1. Click on the link provided in the e-mail. If You do not have an account in this shop already, please create a personal account. <br />2. After having added a product to Your shopping cart, You can enter Your coupon code.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Problems?</strong></td></tr>\r\n<tr>\r\n<td class="main">If You have trouble or problems in using Your coupons, please check back with us via our e-mail: you@yourdomain.com. Please describe the encountered problem as detailed as possible! We need the following information to process Your request quickly: Your user id, the coupon code, error messages the shop system returned to You, and the name of the web browser You are using (e.g. "Internet Explorer 6" or "Firefox 1.5"). </td></tr></tbody></table>';
UPDATE `content_manager` SET `content_text` = '<p><strong>Gutscheine kaufen </strong></p>\r\n<p>Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</p>\r\n<p><strong>Wie man Gutscheine versendet</strong></p>\r\n<p>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</p>\r\n<p><strong>Mit Gutscheinen einkaufen.</strong></p>\r\n<p>Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</p>\r\n<p><strong>Gutscheine verbuchen. </strong></p>\r\n<p>Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen:<br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen.<br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</p>\r\n<p><strong>Falls es zu Problemen kommen sollte:</strong></p>\r\n<p>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5").</p>' WHERE `content_text` = '<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine kaufen </strong></td></tr>\r\n<tr>\r\n<td class="main">Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Wie man Gutscheine versendet</strong></td></tr>\r\n<tr>\r\n<td class="main">Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Mit Gutscheinen einkaufen.</strong></td></tr>\r\n<tr>\r\n<td class="main">Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine verbuchen. </strong></td></tr>\r\n<tr>\r\n<td class="main">Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen: <br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen. <br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Falls es zu Problemen kommen sollte:</strong></td></tr>\r\n<tr>\r\n<td class="main">Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5"). </td></tr></tbody></table>';
# shop version 1.05 - 2.0.0.0
UPDATE `content_manager` SET `content_text` = '<p><strong>Gutscheine kaufen </strong></p>\r\n<p>Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</p>\r\n<p><strong>Wie man Gutscheine versendet</strong></p>\r\n<p>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</p>\r\n<p><strong>Mit Gutscheinen einkaufen.</strong></p>\r\n<p>Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</p>\r\n<p><strong>Gutscheine verbuchen. </strong></p>\r\n<p>Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen:<br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen.<br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</p>\r\n<p><strong>Falls es zu Problemen kommen sollte:</strong></p>\r\n<p>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5").</p>' WHERE `content_text` = '<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine kaufen </strong></td></tr>\r\n<tr>\r\n<td class="main">Gutscheine k&ouml;nnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Wie man Gutscheine versendet</strong></td></tr>\r\n<tr>\r\n<td class="main">Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Mit Gutscheinen einkaufen.</strong></td></tr>\r\n<tr>\r\n<td class="main">Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine verbuchen. </strong></td></tr>\r\n<tr>\r\n<td class="main">Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen: <br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen. <br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Falls es zu Problemen kommen sollte:</strong></td></tr>\r\n<tr>\r\n<td class="main">Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5"). </td></tr></tbody></table>';
# shop version 2.0.1.0 - 2.0.4.2
UPDATE `content_manager` SET `content_text` = '<p><strong>Gutscheine kaufen </strong></p>\r\n<p>Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</p>\r\n<p><strong>Wie man Gutscheine versendet</strong></p>\r\n<p>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</p>\r\n<p><strong>Mit Gutscheinen einkaufen.</strong></p>\r\n<p>Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</p>\r\n<p><strong>Gutscheine verbuchen. </strong></p>\r\n<p>Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen:<br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen.<br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</p>\r\n<p><strong>Falls es zu Problemen kommen sollte:</strong></p>\r\n<p>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5").</p>' WHERE `content_text` = '<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine kaufen </strong></td></tr>\r\n<tr>\r\n<td class="main">Gutscheine k&ouml;nnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun k&ouml;nnen Sie &uuml;ber den Link " Gutschein versenden " den gew&uuml;nschten Betrag per E-Mail versenden.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Wie man Gutscheine versendet</strong></td></tr>\r\n<tr>\r\n<td class="main">Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, ben&ouml;tigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empf&auml;ngers. Eine g&uuml;ltige E-Mail Adresse des Empf&auml;ngers. Den gew&uuml;nschten Betrag (Sie k&ouml;nnen auch Teilbetr&auml;ge Ihres Guthabens versenden). Eine kurze Nachricht an den Empf&auml;nger. Bitte &uuml;berpr&uuml;fen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die M&ouml;glichkeit Ihre Angaben zu korrigieren.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Mit Gutscheinen einkaufen.</strong></td></tr>\r\n<tr>\r\n<td class="main">Sobald Sie &uuml;ber ein Guthaben verf&uuml;gen, k&ouml;nnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. W&auml;hrend des Bestellvorganges haben Sie die M&ouml;glichkeit Ihr Guthaben einzul&ouml;sen. Falls das Guthaben unter dem Warenwert liegt m&uuml;ssen Sie Ihre bevorzugte Zahlungsweise f&uuml;r den Differenzbetrag w&auml;hlen. &Uuml;bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverst&auml;ndlich f&uuml;r Ihre n&auml;chste Bestellung zur Verf&uuml;gung.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine verbuchen. </strong></td></tr>\r\n<tr>\r\n<td class="main">Wenn Sie einen Gutschein per E-Mail erhalten haben, k&ouml;nnen Sie den Betrag wie folgt verbuchen: <br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht &uuml;ber ein pers&ouml;nliches Kundenkonto verf&uuml;gen, haben Sie die M&ouml;glichkeit ein Konto zu er&ouml;ffnen. <br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, k&ouml;nnen Sie dort Ihren Gutscheincode eingeben.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Falls es zu Problemen kommen sollte:</strong></td></tr>\r\n<tr>\r\n<td class="main">Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie m&ouml;glichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5"). </td></tr></tbody></table>';
# shop version 2.0.5.0 - 2.0.6.0
UPDATE `content_manager` SET `content_text` = '<p><strong>Gutscheine kaufen </strong></p>\r\n<p>Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</p>\r\n<p><strong>Wie man Gutscheine versendet</strong></p>\r\n<p>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</p>\r\n<p><strong>Mit Gutscheinen einkaufen.</strong></p>\r\n<p>Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</p>\r\n<p><strong>Gutscheine verbuchen. </strong></p>\r\n<p>Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen:<br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen.<br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</p>\r\n<p><strong>Falls es zu Problemen kommen sollte:</strong></p>\r\n<p>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5").</p>' WHERE `content_text` = '<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine kaufen </strong></td></tr>\r\n<tr>\r\n<td class="main">Gutscheine knnen, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun knnen Sie ber den Link " Gutschein versenden " den gewnschten Betrag per E-Mail versenden.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Wie man Gutscheine versendet</strong></td></tr>\r\n<tr>\r\n<td class="main">Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, bentigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfngers. Eine gltige E-Mail Adresse des Empfngers. Den gewnschten Betrag (Sie knnen auch Teilbetrge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfnger. Bitte berprfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Mglichkeit Ihre Angaben zu korrigieren.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Mit Gutscheinen einkaufen.</strong></td></tr>\r\n<tr>\r\n<td class="main">Sobald Sie ber ein Guthaben verfgen, knnen Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Whrend des Bestellvorganges haben Sie die Mglichkeit Ihr Guthaben einzulsen. Falls das Guthaben unter dem Warenwert liegt mssen Sie Ihre bevorzugte Zahlungsweise fr den Differenzbetrag whlen. bersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverstndlich fr Ihre nchste Bestellung zur Verfgung.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Gutscheine verbuchen. </strong></td></tr>\r\n<tr>\r\n<td class="main">Wenn Sie einen Gutschein per E-Mail erhalten haben, knnen Sie den Betrag wie folgt verbuchen: <br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht ber ein persnliches Kundenkonto verfgen, haben Sie die Mglichkeit ein Konto zu erffnen. <br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, knnen Sie dort Ihren Gutscheincode eingeben.</td></tr></tbody></table>\r\n<table cellSpacing="0" cellPadding="0">\r\n<tbody>\r\n<tr>\r\n<td class="main"><strong>Falls es zu Problemen kommen sollte:</strong></td></tr>\r\n<tr>\r\n<td class="main">Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail: you@yourdomain.com. Bitte beschreiben Sie mglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser (z.B. "Internet Explorer 6" oder "Firefox 1.5"). </td></tr></tbody></table>';

#GTB - 2021-11-22 - add index
ALTER TABLE `banners` ADD KEY `idx_banners_group_id` (`banners_group_id`);
ALTER TABLE `customers` ADD KEY `idx_customers_status` (`customers_status`);
ALTER TABLE `customers_status_history` ADD KEY `idx_customers_id` (`customers_id`);
ALTER TABLE `orders` ADD KEY `idx_customers_status` (`customers_status`);
ALTER TABLE `orders_status_history` ADD KEY `idx_orders_status_id` (`orders_status_id`);
ALTER TABLE `orders_tracking` ADD KEY `idx_carrier_id` (`carrier_id`);
ALTER TABLE `products_images` ADD KEY `idx_image_name` (`image_name`);
ALTER TABLE `zones_to_geo_zones` ADD KEY `idx_zone_country_id` (`zone_country_id`);

#Tomcraft - 2021-12-11 - Change country name to North Macedonia
UPDATE `countries` SET `countries_name` = 'North Macedonia' WHERE countries_id = 126;

#Tomcraft - 2022-01-11 - Replace "Imprint" with "Legal Notice"
UPDATE `content_manager` SET `content_title` = 'Legal Notice' WHERE `content_id` = 4 AND `content_title` = 'Imprint';
UPDATE `content_manager` SET `content_heading` = 'Legal Notice' WHERE `content_id` = 4 AND `content_heading` = 'Imprint';

#GTB - 2022-01-11 - fix #1954 - fix NULL customer details
ALTER TABLE `address_book` MODIFY `entry_company` VARCHAR(64) NOT NULL;
ALTER TABLE `address_book` MODIFY `entry_suburb` VARCHAR(32) NOT NULL;
ALTER TABLE `address_book` MODIFY `entry_state` VARCHAR(64) NOT NULL;
ALTER TABLE `customers` MODIFY `customers_cid` VARCHAR(32) NOT NULL;
ALTER TABLE `customers` MODIFY `customers_vat_id` VARCHAR(20) NOT NULL;
ALTER TABLE `customers` MODIFY `customers_warning` VARCHAR(32) NOT NULL;
ALTER TABLE `customers` MODIFY `customers_fax` VARCHAR(32) NOT NULL;

#GTB - 2022-01-12 - fix #1432 - removed shopgate
ALTER TABLE `admin_access` DROP `shopgate`;

#GTB - 2022-02-16 - fix #2165 - add sort_order for countries
ALTER TABLE `countries` ADD `sort_order` INT(4) NOT NULL DEFAULT 0;
ALTER TABLE `countries` ADD KEY `idx_sort_order` (`sort_order`);
UPDATE `countries` SET `sort_order` = 100;

#GTB - 2022-02-16 - fix #1700 - add manufacturers_title
ALTER TABLE `manufacturers_info` ADD `manufacturers_title` VARCHAR(255) NOT NULL DEFAULT '' AFTER `languages_id`;

#GTB - 2022-04-20 - fix #1157 - add index
ALTER TABLE `customers` ADD KEY `idx_account_type` (`account_type`);
ALTER TABLE `content_manager` ADD KEY `idx_content_active` (`content_active`);

#GTB - 2022-04-27 - add index orders_ident_key
ALTER TABLE `orders` ADD KEY `idx_orders_ident_key` (`orders_ident_key`);

#GTB - 2022-05-04 - change whois url
UPDATE `configuration` SET `configuration_value` = 'https://utrace.me/?query=' WHERE `configuration_value` = 'http://www.utrace.de/?query=';

#Tomcraft - 2022-05-06 - add dhl
ALTER TABLE `admin_access` ADD `dhl` INT(1) NOT NULL DEFAULT '0' AFTER `semknox`;
UPDATE `admin_access` SET `dhl` = 1 WHERE `customers_id` = 1 LIMIT 1;
UPDATE `admin_access` SET `dhl` = 9 WHERE `customers_id` = 'groups' LIMIT 1;

#GTB - 2022-05-11 - add specials_old_products_price
ALTER TABLE `specials` ADD `specials_old_products_price` DECIMAL(15,4) NOT NULL AFTER `specials_quantity`;

#GTB - 2022-05-11 - add reviews info
INSERT INTO configuration (configuration_id,  configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES   ('', 'REVIEWS_PURCHASED_INFOS', '', 17, 32, NULL, NOW(), NULL, 'xtc_cfg_select_content(\'REVIEWS_PURCHASED_INFOS\',');
INSERT INTO `content_manager` (`content_id`, `languages_id`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `content_status`, `content_active`, `content_group`, `content_delete`, `content_meta_robots`, `date_added`)
  SELECT MAX(content_id)+1, '1','Information on the authenticity of customer reviews','Information on the authenticity of customer reviews','Put here your Information on the authenticity of customer reviews.<br /><h2>Text suggestions [Select applicable]</h2><br /><h3>No verification of the authenticity of customer reviews</h3><br />The reviews are not checked for authenticity before they are published. They can therefore also come from consumers who have not actually purchased/used the rated products.<br /><br />--- or ---<br /><br /><h3>Verification of the authenticity of consumer reviews</h3><br />Each consumer review is verified for authenticity before it is published, ensuring that reviews only come from consumers who have actually purchased/used the products being reviewed.<br /><br />The verification is done [Select applicable]<br /><ul><li>by manual verification in the form of a comparison of the rating with the order history of the merchandise management system in order to make a previous product purchase a necessary condition for publication.</li><li>by sending individualised links to consumers after the completion of an online order that lead to an online rating form and ensure that access to the rating function is only granted to consumers who have actually purchased a product.</li></ul>','0','1','','0','1',MAX(content_group)+1,'0','', NOW() FROM content_manager;
INSERT INTO `content_manager` (`content_id`, `languages_id`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `content_status`, `content_active`, `content_group`, `content_delete`, `content_meta_robots`, `date_added`)
  SELECT MAX(content_id)+1, '2','Informationen zur Echtheit der Kundenbewertungen','Informationen zur Echtheit der Kundenbewertungen','F&uuml;gen Sie hier Ihre Informationen zur Echtheit der Kundenbewertungen ein.<br /><h2>Textvorschl&auml;ge [Zutreffendes ausw&auml;hlen]</h2><br /><h3>Keine &Uuml;berpr&uuml;fung der Echtheit von Kundenbewertungen</h3><br />Die Bewertungen werden vor ihrer Ver&ouml;ffentlichung nicht auf ihre Echtheit &uuml;berpr&uuml;ft. Sie k&ouml;nnen daher auch von Verbrauchern stammen, die die bewerteten Produkte tats&auml;chlich gar nicht erworben/genutzt haben.<br /><br />--- oder ---<br /><br /><h3>&Uuml;berpr&uuml;fung der Echtheit von Kundenbewertungen</h3><br />Jede Verbraucherbewertung wird vor ihrer Ver&ouml;ffentlichung auf ihre Echtheit &uuml;berpr&uuml;ft, sodass sichergestellt ist, dass Bewertungen nur von Verbrauchern stammen, die die bewerteten Produkte auch tats&auml;chlich erworben/genutzt haben.<br /><br />Die &Uuml;berpr&uuml;fung geschieht [Zutreffendes ausw&auml;hlen]<br /><ul><li>durch manuelle &Uuml;berpr&uuml;fung in Form eines Abgleichs der Bewertung mit der Bestellhistorie des Warenwirtschaftssystems, um einen vorangegangenen Produkterwerb zur notwendigen Bedingung f&uuml;r die Ver&ouml;ffentlichung zu machen.</li><li>durch &Uuml;bermittlung individualisierter Links an Verbraucher nach Abschluss einer Online-Bestellung, die zu einem Online-Bewertungsformular f&uuml;hren und die sicherstellen, dass der Zugang zur Bewertungsfunktion nur solchen Verbrauchern gew&auml;hrt wird, die ein Produkt auch tats&auml;chlich erworben haben</li></ul>','0','1','','0','1',MAX(content_group),'0','', NOW() FROM content_manager;
UPDATE configuration SET configuration_value = (SELECT MAX(content_group) FROM content_manager) WHERE configuration_key = 'REVIEWS_PURCHASED_INFOS';

# Keep an empty line at the end of this file for the db_updater to work properly