<?php
/* -----------------------------------------------------------------------------------------
   $Id: language.php 13736 2021-09-20 11:48:45Z GTB $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(language.php,v 1.4 2003/02/11); www.oscommerce.com
   (c) 2003 nextcommerce (language.php,v 1.6 2003/08/13); www.nextcommerce.org
   (c) 2006 XT-Commerce (language.php 962 2005-05-27)

   Copyright phpMyAdmin (select_lang.lib.php3 v1.24 04/19/2002)
   Copyright Stephane Garin <sgarin@sgarin.com> (detect_language.php v0.1 04/02/2002)

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
   
  if (!class_exists('language')) {
    class language {
      var $languages, $catalog_languages, $browser_languages, $language;

      function __construct($lng = '') {
        $this->languages = array(
          'ar' => array('ar([-_][[:alpha:]]{2})?|arabic', 'arabic', 'ar'),
          'bg-win1251' => array('bg|bulgarian', 'bulgarian-win1251', 'bg'),
          'bg-koi8r' => array('bg|bulgarian', 'bulgarian-koi8', 'bg'),
          'ca' => array('ca|catalan', 'catala', 'ca'),
          'cs-iso' => array('cs|czech', 'czech-iso', 'cs'),
          'cs-win1250' => array('cs|czech', 'czech-win1250', 'cs'),
          'da' => array('da|danish', 'danish', 'da'),
          'de' => array('de([-_][[:alpha:]]{2})?|german', 'german', 'de'),
          'el' => array('el|greek',  'greek', 'el'),
          'en' => array('en([-_][[:alpha:]]{2})?|english', 'english', 'en'),
          'es' => array('es([-_][[:alpha:]]{2})?|spanish', 'spanish', 'es'),
          'et' => array('et|estonian', 'estonian', 'et'),
          'fi' => array('fi|finnish', 'finnish', 'fi'),
          'fr' => array('fr([-_][[:alpha:]]{2})?|french', 'french', 'fr'),
          'gl' => array('gl|galician', 'galician', 'gl'),
          'he' => array('he|hebrew', 'hebrew', 'he'),
          'hu' => array('hu|hungarian', 'hungarian', 'hu'),
          'id' => array('id|indonesian', 'indonesian', 'id'),
          'it' => array('it|italian', 'italian', 'it'),
          'ja-euc' => array('ja|japanese', 'japanese-euc', 'ja'),
          'ja-sjis' => array('ja|japanese', 'japanese-sjis', 'ja'),
          'ko' => array('ko|korean', 'korean', 'ko'),
          'ka' => array('ka|georgian', 'georgian', 'ka'),
          'lt' => array('lt|lithuanian', 'lithuanian', 'lt'),
          'lv' => array('lv|latvian', 'latvian', 'lv'),
          'nl' => array('nl([-_][[:alpha:]]{2})?|dutch', 'dutch', 'nl'),
          'no' => array('no|norwegian', 'norwegian', 'no'),
          'pl' => array('pl|polish', 'polish', 'pl'),
          'pt-br' => array('pt[-_]br|brazilian portuguese', 'brazilian_portuguese', 'pt-BR'),
          'pt' => array('pt([-_][[:alpha:]]{2})?|portuguese', 'portuguese', 'pt'),
          'ro' => array('ro|romanian', 'romanian', 'ro'),
          'ru-koi8r' => array('ru|russian', 'russian-koi8', 'ru'),
          'ru-win1251' => array('ru|russian', 'russian-win1251', 'ru'),
          'sk' => array('sk|slovak', 'slovak-iso', 'sk'),
          'sk-win1250' => array('sk|slovak', 'slovak-win1250', 'sk'),
          'sr-win1250' => array('sr|serbian', 'serbian-win1250', 'sr'),
          'sv' => array('sv|swedish', 'swedish', 'sv'),
          'th' => array('th|thai', 'thai', 'th'),
          'tr' => array('tr|turkish', 'turkish', 'tr'),
          'uk-win1251' => array('uk|ukrainian', 'ukrainian-win1251', 'uk'),
          'zh-tw' => array('zh[-_]tw|chinese traditional', 'chinese_big5', 'zh-TW'),
          'zh' => array('zh|chinese simplified', 'chinese_gb', 'zh'),
        );

        $this->catalog_languages = $this->get_catalog_languages();
        $this->browser_languages = '';
        $this->language = '';

        if ( (!empty($lng)) && (isset($this->catalog_languages[$lng])) ) {
          $this->language = $this->catalog_languages[$lng];        
        } elseif(isset($this->catalog_languages[DEFAULT_LANGUAGE])) {
          $this->language = $this->catalog_languages[DEFAULT_LANGUAGE];
        } else {
          $this->language = $this->catalog_languages[key($this->catalog_languages)];
        }
      }
    
      function get_catalog_languages() {
        static $languages_array;
      
        if (!isset($languages_array)) {
          $languages_array = array();
        
          $where = !defined('RUN_MODE_ADMIN') ? ((isset($_SESSION['customers_status']['customers_status']) && $_SESSION['customers_status']['customers_status'] == '0') ? "WHERE status_admin = '1'" : "WHERE status = '1'") : '';
          $languages_query = xtDBquery("SELECT * 
                                          FROM " . TABLE_LANGUAGES . " 
                                               ".$where." 
                                      ORDER BY sort_order");
          while ($languages = xtc_db_fetch_array($languages_query, true)) {
            $languages_array[$languages['code']] = $languages;
            $languages_array[$languages['code']]['id'] = $languages['languages_id'];
          }
        }
      
        return $languages_array;
      }
    
      function get_browser_language() {
        $this->browser_languages = explode(',', (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : ''));
        for ($i=0, $n=sizeof($this->browser_languages); $i<$n; $i++) {
          reset($this->languages);
          foreach ($this->languages as $key => $value) {
            if (preg_match('/^(' . $value[0] . ')(;q=[0-9]\\.[0-9])?$/i', $this->browser_languages[$i]) && isset($this->catalog_languages[$key])) {
              $this->language = $this->catalog_languages[$key];
              break 2;
            }
          }
        }
      }
    }
  }
